/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.conf;

import java.io.Serializable;
import java.util.Arrays;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.ValueSelector;

public class AttributeFilter
implements Serializable {
    private static final long serialVersionUID = -2417549681350544302L;
    private int[] selection;
    private Attributes.UpdatePolicy attributeUpdatePolicy = Attributes.UpdatePolicy.PRESERVE;
    private ValueSelector customAttribute1;
    private ValueSelector customAttribute2;
    private ValueSelector customAttribute3;

    public AttributeFilter() {
    }

    public AttributeFilter(int ... selection) {
        this.setSelection(selection);
    }

    public int[] getSelection() {
        return this.selection;
    }

    public int[] getSelection(boolean withOriginalAttributesSequence) {
        int index = Arrays.binarySearch(this.selection, 67110241);
        if (withOriginalAttributesSequence) {
            if (index < 0) {
                return AttributeFilter.includeOriginalAttributesSequence(this.selection, -(index + 1));
            }
        } else if (index >= 0) {
            return AttributeFilter.removeOriginalAttributesSequence(this.selection, index);
        }
        return this.selection;
    }

    private static int[] includeOriginalAttributesSequence(int[] selection, int index) {
        int[] result = new int[selection.length + 1];
        System.arraycopy(selection, 0, result, 0, index);
        result[index] = 67110241;
        System.arraycopy(selection, index, result, index + 1, selection.length - index);
        return result;
    }

    private static int[] removeOriginalAttributesSequence(int[] selection, int index) {
        int[] result = new int[selection.length - 1];
        System.arraycopy(selection, 0, result, 0, index);
        System.arraycopy(selection, index + 1, result, index - 1, selection.length - index - 1);
        return result;
    }

    public void setSelection(int[] selection) {
        this.selection = selection;
        Arrays.sort(selection);
    }

    public Attributes.UpdatePolicy getAttributeUpdatePolicy() {
        return this.attributeUpdatePolicy;
    }

    public void setAttributeUpdatePolicy(Attributes.UpdatePolicy attributeUpdatePolicy) {
        this.attributeUpdatePolicy = attributeUpdatePolicy;
    }

    public static String selectStringValue(Attributes attrs, ValueSelector selector, String defVal) {
        return selector != null ? selector.selectStringValue(attrs, defVal) : defVal;
    }

    public void setCustomAttribute1(ValueSelector customAttribute1) {
        this.customAttribute1 = customAttribute1;
    }

    public ValueSelector getCustomAttribute1() {
        return this.customAttribute1;
    }

    public void setCustomAttribute2(ValueSelector customAttribute2) {
        this.customAttribute2 = customAttribute2;
    }

    public ValueSelector getCustomAttribute2() {
        return this.customAttribute2;
    }

    public void setCustomAttribute3(ValueSelector customAttribute3) {
        this.customAttribute3 = customAttribute3;
    }

    public ValueSelector getCustomAttribute3() {
        return this.customAttribute3;
    }
}

