/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.compress.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.dcm4che3.util.StringUtils;
import org.dcm4chee.arc.entity.Location;
import org.dcm4chee.arc.entity.Series;
import org.dcm4chee.arc.query.impl.QuerySizeEJB;

@Stateless
public class CompressionEJB {
    @PersistenceContext(unitName="dcm4chee-arc")
    private EntityManager em;
    @Inject
    private QuerySizeEJB querySizeEJB;

    public List<Series.Compression> findSeriesForCompression(int fetchSize) {
        return this.em.createNamedQuery("Series.scheduledCompression", Series.Compression.class).setMaxResults(fetchSize).getResultList();
    }

    public boolean claimForCompression(Series.Compression compression) {
        return this.em.createNamedQuery("Series.claimCompression").setParameter(1, (Object)compression.seriesPk).setParameter(2, (Object)compression.compressionTime).executeUpdate() > 0;
    }

    public void updateDB(Series.Compression compr, int completed, int failures) {
        if (completed > 0) {
            this.querySizeEJB.calculateSeriesSize(compr.seriesPk);
            this.querySizeEJB.calculateStudySize(compr.studyPk, "Study.setStudySize");
            this.em.createNamedQuery("Series.scheduleMetadataUpdateForSeries").setParameter(1, (Object)compr.seriesPk);
            this.em.createNamedQuery(failures > 0 ? "Series.updateCompressionFailuresAndTSUID" : "Series.updateCompressionCompleted").setParameter(1, (Object)compr.seriesPk).setParameter(2, (Object)failures).setParameter(3, (Object)compr.transferSyntaxUID).executeUpdate();
            List storageIDs = this.em.createNamedQuery("Location.StorageIDsByStudyPkAndObjectType", String.class).setParameter(1, (Object)compr.studyPk).setParameter(2, (Object)Location.ObjectType.DICOM_FILE).getResultList();
            Collections.sort(storageIDs);
            this.em.createNamedQuery("Study.setStorageIDs").setParameter(1, (Object)compr.studyPk).setParameter(2, (Object)StringUtils.concat((Collection)storageIDs, (char)'\\'));
        } else if (failures > 0) {
            this.em.createNamedQuery("Series.updateCompressionFailures").setParameter(1, (Object)compr.seriesPk).setParameter(2, (Object)failures).executeUpdate();
        } else {
            this.em.createNamedQuery("Series.updateCompressionCompleted").setParameter(1, (Object)compr.seriesPk).setParameter(2, (Object)failures).setParameter(3, (Object)compr.transferSyntaxUID).executeUpdate();
        }
    }
}

