/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.coerce.impl;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Named;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.io.SAXTransformer;
import org.dcm4che3.io.TemplatesCache;
import org.dcm4che3.util.StringUtils;
import org.dcm4chee.arc.coerce.CoercionProcessor;
import org.dcm4chee.arc.conf.ArchiveAttributeCoercion2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@Named(value="xslt")
public class XSLTCoercionProcessor
implements CoercionProcessor {
    static final Logger LOG = LoggerFactory.getLogger(XSLTCoercionProcessor.class);

    public boolean coerce(ArchiveAttributeCoercion2 coercion, String sopClassUID, String sendingHost, String sendingAET, String receivingHost, String receivingAET, Attributes attrs, Attributes modified) throws Exception {
        String xsltStylesheetURI = coercion.getSchemeSpecificPart();
        Templates tpls = TemplatesCache.getDefault().get(StringUtils.replaceSystemProperties((String)xsltStylesheetURI));
        Attributes newAttrs = SAXTransformer.transform((Attributes)attrs, (Templates)tpls, (boolean)false, (!coercion.parseBooleanCoercionParam("xsl-no-keyword") ? 1 : 0) != 0, t -> XSLTCoercionProcessor.setParameters(t, sendingHost, sendingAET, receivingHost, receivingAET));
        if (modified != null) {
            attrs.update(Attributes.UpdatePolicy.OVERWRITE, newAttrs, modified);
        } else {
            attrs.addAll(newAttrs);
        }
        LOG.info("Coerced attributes from stylesheet by coercion {}", (Object)coercion);
        return true;
    }

    private static void setParameters(Transformer t, String sendingHost, String sendingAET, String receivingHost, String receivingAET) {
        XSLTCoercionProcessor.setParameter(t, "SendingHostname", sendingHost);
        XSLTCoercionProcessor.setParameter(t, "SendingApplicationEntityTitle", sendingAET);
        XSLTCoercionProcessor.setParameter(t, "ReceivingHostname", receivingHost);
        XSLTCoercionProcessor.setParameter(t, "ReceivingApplicationEntityTitle", receivingAET);
    }

    private static void setParameter(Transformer t, String name, String value) {
        if (value != null) {
            t.setParameter(name, value);
        }
    }
}

