/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.coerce.impl;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Named;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Sequence;
import org.dcm4che3.data.VR;
import org.dcm4chee.arc.coerce.CoercionProcessor;
import org.dcm4chee.arc.conf.ArchiveAttributeCoercion2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@Named(value="use-calling-aet-as")
public class UseCallingAETAsCoercionProcessor
implements CoercionProcessor {
    static final Logger LOG = LoggerFactory.getLogger(UseCallingAETAsCoercionProcessor.class);

    public boolean coerce(ArchiveAttributeCoercion2 coercion, String sopClassUID, String sendingHost, String sendingAET, String receivingHost, String receivingAET, Attributes attrs, Attributes coercedAttributes) throws Exception {
        String type;
        switch (type = coercion.getSchemeSpecificPart()) {
            case "ScheduledStationAETitle": {
                return this.addScheduledStationAETitle(coercion, sendingAET, attrs);
            }
            case "SendingApplicationEntityTitleOfSeries": {
                return this.addSendingApplicationEntityTitleOfSeries(coercion, sendingAET, attrs);
            }
        }
        LOG.warn("Ignore unsupported {}", (Object)coercion);
        return false;
    }

    private boolean addSendingApplicationEntityTitleOfSeries(ArchiveAttributeCoercion2 coercion, String sendingAET, Attributes attrs) {
        if (attrs.containsValue("DCM4CHEE Archive 5", 0x77770037)) {
            return false;
        }
        attrs.setString("DCM4CHEE Archive 5", 0x77770037, VR.AE, sendingAET);
        LOG.info("Filter by Calling AET as Sending Application Entity Title Of Series by {}", (Object)coercion);
        return true;
    }

    private boolean addScheduledStationAETitle(ArchiveAttributeCoercion2 coercion, String sendingAET, Attributes attrs) {
        Attributes sps;
        Sequence sq = attrs.ensureSequence(0x400100, 1);
        if (sq.isEmpty()) {
            sq.add(new Attributes(20));
        }
        if ((sps = (Attributes)sq.get(0)).containsValue(0x400001)) {
            return false;
        }
        if (sps.isEmpty()) {
            sps.setNull(524384, VR.CS);
            sps.setNull(0x102210, VR.CS);
            sps.setNull(1612044, VR.SQ);
            sps.setNull(1612045, VR.SQ);
            sps.setNull(3281008, VR.LO);
            sps.setNull(0x400002, VR.DA);
            sps.setNull(0x400003, VR.TM);
            sps.setNull(0x400004, VR.DA);
            sps.setNull(0x400005, VR.TM);
            sps.setNull(0x400006, VR.PN);
            sps.setNull(0x400007, VR.LO);
            sps.setNull(0x400008, VR.SQ);
            sps.setNull(0x400009, VR.SH);
            sps.setNull(0x40000B, VR.SQ);
            sps.setNull(0x400010, VR.SH);
            sps.setNull(0x400011, VR.SH);
            sps.setNull(4194322, VR.LO);
            sps.setNull(0x400020, VR.CS);
            sps.setNull(0x400400, VR.LT);
        }
        sps.setString(0x400001, VR.AE, sendingAET);
        LOG.info("Filter MWL by Calling AET by {}", (Object)coercion);
        return true;
    }
}

