/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.code.impl;

import javax.ejb.EJBException;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.dcm4che3.data.Code;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.service.DicomServiceException;
import org.dcm4chee.arc.code.CodeService;
import org.dcm4chee.arc.code.impl.CodeServiceEJB;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.entity.CodeEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class CodeServiceImpl
implements CodeService {
    static final Logger LOG = LoggerFactory.getLogger(CodeServiceImpl.class);
    @Inject
    private CodeServiceEJB ejb;
    @Inject
    private Device device;

    @Override
    public CodeEntity findOrCreate(Code code) {
        ArchiveDeviceExtension arcDev = (ArchiveDeviceExtension)this.device.getDeviceExtension(ArchiveDeviceExtension.class);
        int retries = arcDev.getStoreUpdateDBMaxRetries();
        while (true) {
            try {
                return this.ejb.findOrCreate(code);
            }
            catch (EJBException e) {
                if (retries-- <= 0) {
                    LOG.warn("Failed to update DB:\n", (Throwable)e);
                    throw e;
                }
                LOG.info("Failed to update DB caused by {} - retry", (Object)DicomServiceException.initialCauseOf((Throwable)e).toString());
                LOG.debug("Failed to update DB - retry:\n", (Throwable)e);
                try {
                    Thread.sleep(arcDev.storeUpdateDBRetryDelay());
                    continue;
                }
                catch (InterruptedException e2) {
                    LOG.info("Failed to delay retry to update DB:\n", (Throwable)e2);
                    continue;
                }
            }
            break;
        }
    }
}

