/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.audit;

import java.nio.file.Path;
import java.util.HashSet;
import org.dcm4che3.audit.ActiveParticipant;
import org.dcm4che3.audit.ActiveParticipantBuilder;
import org.dcm4che3.audit.AuditMessage;
import org.dcm4che3.audit.AuditMessages;
import org.dcm4che3.audit.EventIdentification;
import org.dcm4che3.audit.ParticipantObjectIdentification;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Sequence;
import org.dcm4che3.net.Connection;
import org.dcm4che3.net.audit.AuditLogger;
import org.dcm4chee.arc.audit.AuditInfo;
import org.dcm4chee.arc.audit.AuditInfoBuilder;
import org.dcm4chee.arc.audit.AuditService;
import org.dcm4chee.arc.audit.AuditUtils;
import org.dcm4chee.arc.audit.EventID;
import org.dcm4chee.arc.audit.ParticipantObjectID;
import org.dcm4chee.arc.audit.SpoolFileReader;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.keycloak.HttpServletRequestInfo;
import org.dcm4chee.arc.stgcmt.StgCmtContext;

class StorageCommitAuditService {
    StorageCommitAuditService() {
    }

    private static String studyIUID(Attributes eventInfo, ArchiveDeviceExtension arcDev) {
        return eventInfo.getStrings(0x20000D) != null ? String.join((CharSequence)";", eventInfo.getStrings(0x20000D)) : arcDev.auditUnknownStudyInstanceUID();
    }

    static AuditInfoBuilder[] getSuccessAuditInfo(StgCmtContext ctx, ArchiveDeviceExtension arcDev) {
        Attributes eventInfo = ctx.getEventInfo();
        Sequence success = eventInfo.getSequence(528793);
        AuditInfoBuilder[] successAuditInfo = new AuditInfoBuilder[success.size() + 1];
        successAuditInfo[0] = new AuditInfoBuilder.Builder().callingUserID(StorageCommitAuditService.storageCmtCallingAET(ctx)).callingHost(StorageCommitAuditService.storageCmtCallingHost(ctx)).calledUserID(StorageCommitAuditService.storageCmtCalledAET(ctx)).pIDAndName(eventInfo, arcDev).studyIUID(StorageCommitAuditService.studyIUID(eventInfo, arcDev)).build();
        for (int i = 1; i <= success.size(); ++i) {
            successAuditInfo[i] = StorageCommitAuditService.buildRefSopAuditInfo((Attributes)success.get(i - 1));
        }
        return successAuditInfo;
    }

    static AuditInfoBuilder[] getFailedAuditInfo(StgCmtContext ctx, ArchiveDeviceExtension arcDev) {
        Attributes eventInfo = ctx.getEventInfo();
        Sequence failed = eventInfo.getSequence(528792);
        AuditInfoBuilder[] failedAuditInfo = new AuditInfoBuilder[failed.size() + 1];
        HashSet<String> failureReasons = new HashSet<String>();
        for (int i = 1; i <= failed.size(); ++i) {
            Attributes item = (Attributes)failed.get(i - 1);
            failedAuditInfo[i] = StorageCommitAuditService.buildRefSopAuditInfo(item);
            failureReasons.add(item.getInt(528791, 0) == 274 ? "NoSuchObjectInstance" : (item.getInt(528791, 0) == 281 ? "ClassInstanceConflict" : "ProcessingFailure"));
        }
        failedAuditInfo[0] = new AuditInfoBuilder.Builder().callingUserID(StorageCommitAuditService.storageCmtCallingAET(ctx)).callingHost(StorageCommitAuditService.storageCmtCallingHost(ctx)).calledUserID(StorageCommitAuditService.storageCmtCalledAET(ctx)).pIDAndName(eventInfo, arcDev).studyIUID(StorageCommitAuditService.studyIUID(eventInfo, arcDev)).outcome(String.join((CharSequence)";", failureReasons)).build();
        return failedAuditInfo;
    }

    private static AuditInfoBuilder buildRefSopAuditInfo(Attributes item) {
        return new AuditInfoBuilder.Builder().sopCUID(item.getString(528720)).sopIUID(item.getString(528725)).build();
    }

    private static String storageCmtCallingHost(StgCmtContext ctx) {
        return ctx.getRequest() != null ? ctx.getRequest().requesterHost : (ctx.getRemoteAE() != null ? ((Connection)ctx.getRemoteAE().getConnections().get(0)).getHostname() : null);
    }

    private static String storageCmtCalledAET(StgCmtContext ctx) {
        return ctx.getRequest() != null ? StorageCommitAuditService.requestURLWithQueryParams(ctx.getRequest()) : ctx.getLocalAET();
    }

    private static String requestURLWithQueryParams(HttpServletRequestInfo httpServletRequestInfo) {
        return httpServletRequestInfo.queryString == null ? httpServletRequestInfo.requestURI : httpServletRequestInfo.requestURI + "?" + httpServletRequestInfo.queryString;
    }

    private static String storageCmtCallingAET(StgCmtContext ctx) {
        return ctx.getRequest() != null ? ctx.getRequest().requesterUserID : (ctx.getRemoteAE() != null ? ctx.getRemoteAE().getAETitle() : null);
    }

    static AuditMessage auditMsg(AuditLogger auditLogger, Path path, AuditUtils.EventType eventType) {
        SpoolFileReader reader = new SpoolFileReader(path);
        AuditInfo auditInfo = new AuditInfo(reader.getMainInfo());
        return AuditMessages.createMessage((EventIdentification)EventID.toEventIdentification(auditLogger, path, eventType, auditInfo), (ActiveParticipant[])StorageCommitAuditService.activeParticipants(eventType, auditLogger, auditInfo), (ParticipantObjectIdentification[])ParticipantObjectID.studyPatParticipants(reader, auditInfo, auditLogger));
    }

    private static ActiveParticipant[] activeParticipants(AuditUtils.EventType eventType, AuditLogger auditLogger, AuditInfo auditInfo) {
        ActiveParticipant[] activeParticipants = new ActiveParticipant[2];
        String archiveUserID = auditInfo.getField(2);
        AuditMessages.UserIDTypeCode archiveUserIDTypeCode = StorageCommitAuditService.archiveUserIDTypeCode(archiveUserID);
        ActiveParticipantBuilder archive = new ActiveParticipantBuilder(archiveUserID, ((Connection)auditLogger.getConnections().get(0)).getHostname()).userIDTypeCode(archiveUserIDTypeCode).altUserID(AuditLogger.processID()).roleIDCode(new AuditMessages.RoleIDCode[]{eventType.destination});
        String callingUserID = auditInfo.getField(1);
        if (callingUserID != null) {
            activeParticipants[1] = new ActiveParticipantBuilder(callingUserID, auditInfo.getField(0)).userIDTypeCode(AuditService.remoteUserIDTypeCode(archiveUserIDTypeCode, callingUserID)).isRequester().roleIDCode(new AuditMessages.RoleIDCode[]{eventType.source}).build();
        } else {
            archive.isRequester();
        }
        activeParticipants[0] = archive.build();
        return activeParticipants;
    }

    private static AuditMessages.UserIDTypeCode archiveUserIDTypeCode(String userID) {
        return userID.indexOf(47) != -1 ? AuditMessages.UserIDTypeCode.URI : AuditMessages.UserIDTypeCode.StationAETitle;
    }
}

