/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.audit;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.dcm4che3.audit.ActiveParticipant;
import org.dcm4che3.audit.ActiveParticipantBuilder;
import org.dcm4che3.audit.AuditMessage;
import org.dcm4che3.audit.AuditMessages;
import org.dcm4che3.audit.EventIdentification;
import org.dcm4che3.audit.ParticipantObjectIdentification;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.net.Connection;
import org.dcm4che3.net.audit.AuditLogger;
import org.dcm4chee.arc.audit.AuditInfo;
import org.dcm4chee.arc.audit.AuditInfoBuilder;
import org.dcm4chee.arc.audit.AuditService;
import org.dcm4chee.arc.audit.AuditUtils;
import org.dcm4chee.arc.audit.EventID;
import org.dcm4chee.arc.audit.InstanceInfo;
import org.dcm4chee.arc.audit.ParticipantObjectID;
import org.dcm4chee.arc.audit.SpoolFileReader;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.keycloak.HttpServletRequestInfo;
import org.dcm4chee.arc.retrieve.RetrieveContext;
import org.dcm4chee.arc.store.InstanceLocations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RetrieveAuditService {
    private static final Logger LOG = LoggerFactory.getLogger(RetrieveAuditService.class);
    private final RetrieveContext ctx;
    private final ArchiveDeviceExtension arcDev;
    private final HttpServletRequestInfo httpServletRequestInfo;
    private final String warningMsg;
    private final String failureMsg;

    RetrieveAuditService(RetrieveContext ctx, ArchiveDeviceExtension arcDev) {
        this.ctx = ctx;
        this.arcDev = arcDev;
        this.httpServletRequestInfo = ctx.getHttpServletRequestInfo();
        this.warningMsg = this.warningMsg();
        this.failureMsg = this.failureMsg();
    }

    Collection<InstanceLocations> failedMatches() {
        if (this.ctx.getFailedMatches().isEmpty()) {
            List<String> failedSOPIUIDs = Arrays.asList(this.ctx.failedSOPInstanceUIDs());
            List<InstanceLocations> failedMatches = this.ctx.getMatches().stream().filter(il -> failedSOPIUIDs.contains(il.getSopInstanceUID())).collect(Collectors.toList());
            if (failedMatches.isEmpty()) {
                LOG.info("Instance information not available for instances failed to be retrieved {}. Exit spooling of retrieve failures", failedSOPIUIDs);
            }
            return failedMatches;
        }
        return this.ctx.getFailedMatches();
    }

    Collection<InstanceLocations> completedMatches() {
        List<String> failedSOPIUIDs = Arrays.asList(this.ctx.failedSOPInstanceUIDs());
        return this.ctx.getMatches().stream().filter(il -> !failedSOPIUIDs.contains(il.getSopInstanceUID())).collect(Collectors.toList());
    }

    List<AuditInfoBuilder> createRetrieveSuccessAuditInfo(Collection<InstanceLocations> completedRetrieves) {
        ArrayList<AuditInfoBuilder> retrieveSuccess = new ArrayList<AuditInfoBuilder>();
        retrieveSuccess.add(this.createCompletedRetrieveInfo());
        this.ctx.getCStoreForwards().forEach(cStoreFwd -> retrieveSuccess.add(this.createInstanceAuditInfo((InstanceLocations)cStoreFwd)));
        completedRetrieves.forEach(completedRetrieve -> retrieveSuccess.add(this.createInstanceAuditInfo((InstanceLocations)completedRetrieve)));
        return retrieveSuccess;
    }

    private AuditInfoBuilder createCompletedRetrieveInfo() {
        AuditInfoBuilder.Builder retrieveInfo = new AuditInfoBuilder.Builder();
        retrieveInfo.warning(this.warningMsg);
        return this.addUserParticipantDetails(retrieveInfo);
    }

    List<AuditInfoBuilder> createRetrieveFailureAuditInfo(Collection<InstanceLocations> failedRetrieves) {
        ArrayList<AuditInfoBuilder> retrieveFailure = new ArrayList<AuditInfoBuilder>();
        retrieveFailure.add(this.createFailedRetrieveInfo());
        this.ctx.getCStoreForwards().forEach(cStoreFwd -> retrieveFailure.add(this.createInstanceAuditInfo((InstanceLocations)cStoreFwd)));
        failedRetrieves.forEach(failedRetrieve -> retrieveFailure.add(this.createInstanceAuditInfo((InstanceLocations)failedRetrieve)));
        return retrieveFailure;
    }

    private AuditInfoBuilder createFailedRetrieveInfo() {
        AuditInfoBuilder.Builder retrieveInfo = new AuditInfoBuilder.Builder();
        retrieveInfo.outcome(this.outcomeDesc());
        retrieveInfo.failedIUIDShow(true);
        return this.addUserParticipantDetails(retrieveInfo);
    }

    private AuditInfoBuilder addUserParticipantDetails(AuditInfoBuilder.Builder retrieveInfo) {
        return this.isExportTriggered(this.ctx) ? (this.httpServletRequestInfo != null ? this.restfulTriggeredExport(retrieveInfo) : this.schedulerTriggeredExport(retrieveInfo)) : (this.httpServletRequestInfo != null ? this.rad69OrWadoRS(retrieveInfo) : this.cMoveCGet(retrieveInfo));
    }

    private AuditInfoBuilder createInstanceAuditInfo(InstanceLocations il) {
        Attributes attrs = il.getAttributes();
        return new AuditInfoBuilder.Builder().studyUIDAccNumDate(attrs, this.arcDev).sopCUID(attrs.getString(524310)).sopIUID(attrs.getString(524312)).pIDAndName(attrs, this.arcDev).build();
    }

    private AuditInfoBuilder cMoveCGet(AuditInfoBuilder.Builder infoBuilder) {
        return infoBuilder.calledUserID(this.ctx.getLocalAETitle()).destUserID(this.ctx.getDestinationAETitle()).destNapID(this.ctx.getDestinationHostName()).callingHost(this.ctx.getRequestorHostName()).moveUserID(this.ctx.getMoveOriginatorAETitle()).build();
    }

    private AuditInfoBuilder rad69OrWadoRS(AuditInfoBuilder.Builder infoBuilder) {
        return infoBuilder.calledUserID(RetrieveAuditService.requestURLWithQueryParams(this.httpServletRequestInfo)).destUserID(this.httpServletRequestInfo.requesterUserID).destNapID(this.ctx.getDestinationHostName()).build();
    }

    private AuditInfoBuilder schedulerTriggeredExport(AuditInfoBuilder.Builder infoBuilder) {
        return infoBuilder.calledUserID(this.ctx.getLocalAETitle()).destUserID(this.ctx.getDestinationAETitle()).destNapID(this.ctx.getDestinationHostName()).callingHost(this.ctx.getRequestorHostName()).isExport().build();
    }

    private AuditInfoBuilder restfulTriggeredExport(AuditInfoBuilder.Builder infoBuilder) {
        return infoBuilder.callingUserID(this.httpServletRequestInfo.requesterUserID).callingHost(this.ctx.getRequestorHostName()).calledUserID(RetrieveAuditService.requestURLWithQueryParams(this.httpServletRequestInfo)).destUserID(this.ctx.getDestinationAETitle()).destNapID(this.ctx.getDestinationHostName()).isExport().build();
    }

    private static String requestURLWithQueryParams(HttpServletRequestInfo httpServletRequestInfo) {
        return httpServletRequestInfo.queryString == null ? httpServletRequestInfo.requestURI : httpServletRequestInfo.requestURI + "?" + httpServletRequestInfo.queryString;
    }

    private boolean isExportTriggered(RetrieveContext ctx) {
        return ctx.getRequestAssociation() == null && ctx.getStoreAssociation() != null || ctx.getRequestAssociation() == null && ctx.getStoreAssociation() == null && ctx.getException() != null;
    }

    private String warningMsg() {
        return this.ctx.warning() > 0 ? "Warnings on retrieve of " + this.ctx.warning() + " instances" : null;
    }

    private String failureMsg() {
        return this.ctx.failed() > 0 || !this.ctx.getFailedMatches().isEmpty() ? "Retrieve of " + this.ctx.failed() + " objects failed" : null;
    }

    private String outcomeDesc() {
        if (this.warningMsg == null && this.failureMsg == null && this.ctx.getException() == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        if (this.warningMsg != null) {
            sb.append(this.warningMsg).append("\n");
        }
        if (this.failureMsg != null) {
            sb.append(this.failureMsg).append("\n");
        }
        if (this.ctx.getException() != null) {
            sb.append(this.ctx.getException().toString()).append("\n");
        }
        return sb.toString();
    }

    static AuditMessage auditMsg(AuditLogger auditLogger, Path path, AuditUtils.EventType eventType) {
        SpoolFileReader reader = new SpoolFileReader(path);
        AuditInfo auditInfo = new AuditInfo(reader.getMainInfo());
        HashMap<String, InstanceInfo> study_instanceInfo = new HashMap<String, InstanceInfo>();
        for (String line : reader.getInstanceLines()) {
            AuditInfo rInfo = new AuditInfo(line);
            String studyInstanceUID = rInfo.getField(4);
            InstanceInfo instanceInfo2 = (InstanceInfo)study_instanceInfo.get(studyInstanceUID);
            if (instanceInfo2 == null) {
                instanceInfo2 = new InstanceInfo();
                instanceInfo2.addAcc(rInfo);
                study_instanceInfo.put(studyInstanceUID, instanceInfo2);
            }
            instanceInfo2.addSOPInstance(rInfo);
            instanceInfo2.addStudyDate(rInfo);
            study_instanceInfo.put(studyInstanceUID, instanceInfo2);
        }
        ArrayList<ParticipantObjectIdentification> pois = new ArrayList<ParticipantObjectIdentification>();
        boolean showIUID = auditInfo.getField(16) != null || auditLogger.isIncludeInstanceUID() != false;
        study_instanceInfo.forEach((studyUID, instanceInfo) -> pois.add(ParticipantObjectID.studyPOI(studyUID, instanceInfo, showIUID)));
        pois.add(ParticipantObjectID.patientPOI(reader));
        return AuditMessages.createMessage((EventIdentification)EventID.toEventIdentification(auditLogger, path, eventType, auditInfo), (ActiveParticipant[])RetrieveAuditService.activeParticipants(eventType, auditInfo, auditLogger), (ParticipantObjectIdentification[])pois.toArray(new ParticipantObjectIdentification[0]));
    }

    private static ActiveParticipant[] activeParticipants(AuditUtils.EventType eventType, AuditInfo auditInfo, AuditLogger auditLogger) {
        return auditInfo.getField(14) != null ? RetrieveAuditService.cMoveActiveParticipants(eventType, auditInfo, auditLogger) : (auditInfo.getField(21) != null ? RetrieveAuditService.exportActiveParticipants(eventType, auditInfo, auditLogger) : RetrieveAuditService.cGetOrWadoRSOrRAD69ActiveParticipants(eventType, auditInfo, auditLogger));
    }

    private static ActiveParticipant[] cMoveActiveParticipants(AuditUtils.EventType eventType, AuditInfo auditInfo, AuditLogger auditLogger) {
        ActiveParticipant[] activeParticipants = new ActiveParticipant[]{new ActiveParticipantBuilder(auditInfo.getField(2), RetrieveAuditService.getLocalHostName(auditLogger)).userIDTypeCode(AuditMessages.UserIDTypeCode.StationAETitle).altUserID(AuditLogger.processID()).roleIDCode(new AuditMessages.RoleIDCode[]{eventType.source}).build(), new ActiveParticipantBuilder(auditInfo.getField(12), auditInfo.getField(13)).userIDTypeCode(AuditMessages.UserIDTypeCode.StationAETitle).roleIDCode(new AuditMessages.RoleIDCode[]{eventType.destination}).build(), new ActiveParticipantBuilder(auditInfo.getField(14), auditInfo.getField(0)).userIDTypeCode(AuditMessages.UserIDTypeCode.StationAETitle).isRequester().build()};
        return activeParticipants;
    }

    private static ActiveParticipant[] exportActiveParticipants(AuditUtils.EventType eventType, AuditInfo auditInfo, AuditLogger auditLogger) {
        ActiveParticipant[] activeParticipants = new ActiveParticipant[3];
        activeParticipants[0] = new ActiveParticipantBuilder(auditInfo.getField(12), auditInfo.getField(13)).userIDTypeCode(AuditMessages.UserIDTypeCode.StationAETitle).roleIDCode(new AuditMessages.RoleIDCode[]{eventType.destination}).build();
        String archiveUserID = auditInfo.getField(2);
        AuditMessages.UserIDTypeCode archiveUserIDTypeCode = RetrieveAuditService.archiveUserIDTypeCode(archiveUserID);
        if (auditInfo.getField(1) == null) {
            activeParticipants[1] = new ActiveParticipantBuilder(archiveUserID, RetrieveAuditService.getLocalHostName(auditLogger)).userIDTypeCode(archiveUserIDTypeCode).altUserID(AuditLogger.processID()).isRequester().roleIDCode(new AuditMessages.RoleIDCode[]{eventType.source}).build();
        } else {
            activeParticipants[1] = new ActiveParticipantBuilder(archiveUserID, RetrieveAuditService.getLocalHostName(auditLogger)).userIDTypeCode(archiveUserIDTypeCode).altUserID(AuditLogger.processID()).roleIDCode(new AuditMessages.RoleIDCode[]{eventType.source}).build();
            String callingUserID = auditInfo.getField(1);
            activeParticipants[2] = new ActiveParticipantBuilder(callingUserID, auditInfo.getField(0)).userIDTypeCode(AuditMessages.userIDTypeCode((String)callingUserID)).isRequester().build();
        }
        return activeParticipants;
    }

    private static ActiveParticipant[] cGetOrWadoRSOrRAD69ActiveParticipants(AuditUtils.EventType eventType, AuditInfo auditInfo, AuditLogger auditLogger) {
        ActiveParticipant[] activeParticipants = new ActiveParticipant[2];
        String archiveUserID = auditInfo.getField(2);
        AuditMessages.UserIDTypeCode archiveUserIDTypeCode = RetrieveAuditService.archiveUserIDTypeCode(archiveUserID);
        activeParticipants[0] = new ActiveParticipantBuilder(archiveUserID, RetrieveAuditService.getLocalHostName(auditLogger)).userIDTypeCode(archiveUserIDTypeCode).altUserID(AuditLogger.processID()).roleIDCode(new AuditMessages.RoleIDCode[]{eventType.source}).build();
        String callingUserID = auditInfo.getField(12);
        activeParticipants[1] = new ActiveParticipantBuilder(callingUserID, auditInfo.getField(13)).userIDTypeCode(AuditService.remoteUserIDTypeCode(archiveUserIDTypeCode, callingUserID)).isRequester().roleIDCode(new AuditMessages.RoleIDCode[]{eventType.destination}).build();
        return activeParticipants;
    }

    private static AuditMessages.UserIDTypeCode archiveUserIDTypeCode(String userID) {
        return userID.indexOf(47) != -1 ? AuditMessages.UserIDTypeCode.URI : AuditMessages.UserIDTypeCode.StationAETitle;
    }

    private static String getLocalHostName(AuditLogger auditLogger) {
        return ((Connection)auditLogger.getConnections().get(0)).getHostname();
    }
}

