/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.audit;

import java.net.URI;
import java.nio.file.Path;
import org.dcm4che3.audit.ActiveParticipant;
import org.dcm4che3.audit.ActiveParticipantBuilder;
import org.dcm4che3.audit.AuditMessage;
import org.dcm4che3.audit.AuditMessages;
import org.dcm4che3.audit.EventIdentification;
import org.dcm4che3.audit.ParticipantObjectIdentification;
import org.dcm4che3.net.Connection;
import org.dcm4che3.net.audit.AuditLogger;
import org.dcm4chee.arc.audit.AuditInfo;
import org.dcm4chee.arc.audit.AuditInfoBuilder;
import org.dcm4chee.arc.audit.AuditUtils;
import org.dcm4chee.arc.audit.EventID;
import org.dcm4chee.arc.audit.ParticipantObjectID;
import org.dcm4chee.arc.audit.SpoolFileReader;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.exporter.ExportContext;
import org.dcm4chee.arc.keycloak.HttpServletRequestInfo;

class ProvideAndRegisterAuditService {
    ProvideAndRegisterAuditService() {
    }

    static AuditInfoBuilder provideRegisterAuditInfo(ExportContext ctx, ArchiveDeviceExtension arcDev) {
        return ctx.getHttpServletRequestInfo() != null ? ProvideAndRegisterAuditService.restfulTriggeredProvideRegisterAuditInfo(ctx, arcDev) : ProvideAndRegisterAuditService.schedulerTriggeredProvideRegisterAuditInfo(ctx, arcDev);
    }

    private static AuditInfoBuilder restfulTriggeredProvideRegisterAuditInfo(ExportContext ctx, ArchiveDeviceExtension arcDev) {
        HttpServletRequestInfo httpServletRequestInfo = ctx.getHttpServletRequestInfo();
        URI destination = ctx.getExporter().getExporterDescriptor().getExportURI();
        return new AuditInfoBuilder.Builder().callingUserID(httpServletRequestInfo.requesterUserID).callingHost(httpServletRequestInfo.requesterHost).calledUserID(ProvideAndRegisterAuditService.requestURLWithQueryParams(httpServletRequestInfo)).destUserID(destination.toString()).destNapID(ProvideAndRegisterAuditService.destinationHost(destination)).outcome(ProvideAndRegisterAuditService.outcome(ctx)).pIDAndName(ctx.getXDSiManifest(), arcDev).submissionSetUID(ctx.getSubmissionSetUID()).build();
    }

    private static AuditInfoBuilder schedulerTriggeredProvideRegisterAuditInfo(ExportContext ctx, ArchiveDeviceExtension arcDev) {
        URI destination = ctx.getExporter().getExporterDescriptor().getExportURI();
        return new AuditInfoBuilder.Builder().callingUserID(arcDev.getDevice().getDeviceName()).destUserID(destination.toString()).destNapID(ProvideAndRegisterAuditService.destinationHost(destination)).outcome(ProvideAndRegisterAuditService.outcome(ctx)).pIDAndName(ctx.getXDSiManifest(), arcDev).submissionSetUID(ctx.getSubmissionSetUID()).build();
    }

    private static String requestURLWithQueryParams(HttpServletRequestInfo httpServletRequestInfo) {
        return httpServletRequestInfo.queryString == null ? httpServletRequestInfo.requestURI : httpServletRequestInfo.requestURI + "?" + httpServletRequestInfo.queryString;
    }

    private static String destinationHost(URI destination) {
        String schemeSpecificPart = destination.getSchemeSpecificPart();
        return schemeSpecificPart.substring(schemeSpecificPart.indexOf("://") + 3, schemeSpecificPart.lastIndexOf(":"));
    }

    private static String outcome(ExportContext ctx) {
        return ctx.getException() != null ? ctx.getException().getMessage() : null;
    }

    static AuditMessage provideRegisterAuditMsg(AuditLogger auditLogger, Path path, AuditUtils.EventType eventType) {
        SpoolFileReader reader = new SpoolFileReader(path);
        AuditInfo auditInfo = new AuditInfo(reader.getMainInfo());
        return AuditMessages.createMessage((EventIdentification)EventID.toEventIdentification(auditLogger, path, eventType, auditInfo), (ActiveParticipant[])ProvideAndRegisterAuditService.activeParticipants(auditLogger, eventType, auditInfo), (ParticipantObjectIdentification[])ParticipantObjectID.submissionSetParticipants(auditInfo));
    }

    private static ActiveParticipant[] activeParticipants(AuditLogger auditLogger, AuditUtils.EventType eventType, AuditInfo auditInfo) {
        ActiveParticipant[] activeParticipants = new ActiveParticipant[3];
        activeParticipants[0] = new ActiveParticipantBuilder(auditInfo.getField(12), auditInfo.getField(13)).userIDTypeCode(AuditMessages.UserIDTypeCode.URI).roleIDCode(new AuditMessages.RoleIDCode[]{eventType.destination}).build();
        String callingUserID = auditInfo.getField(1);
        if (auditInfo.getField(0) != null) {
            activeParticipants[1] = new ActiveParticipantBuilder(auditInfo.getField(2), ProvideAndRegisterAuditService.getLocalHostName(auditLogger)).userIDTypeCode(AuditMessages.UserIDTypeCode.URI).altUserID(AuditLogger.processID()).roleIDCode(new AuditMessages.RoleIDCode[]{eventType.source}).build();
            activeParticipants[2] = new ActiveParticipantBuilder(callingUserID, auditInfo.getField(0)).userIDTypeCode(AuditMessages.userIDTypeCode((String)callingUserID)).isRequester().build();
        } else {
            activeParticipants[1] = new ActiveParticipantBuilder(callingUserID, ProvideAndRegisterAuditService.getLocalHostName(auditLogger)).altUserID(AuditLogger.processID()).userIDTypeCode(AuditMessages.UserIDTypeCode.DeviceName).isRequester().roleIDCode(new AuditMessages.RoleIDCode[]{eventType.source}).build();
        }
        return activeParticipants;
    }

    private static String getLocalHostName(AuditLogger auditLogger) {
        return ((Connection)auditLogger.getConnections().get(0)).getHostname();
    }
}

