/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.audit;

import java.net.InetAddress;
import java.nio.file.Path;
import org.dcm4che3.audit.ActiveParticipant;
import org.dcm4che3.audit.ActiveParticipantBuilder;
import org.dcm4che3.audit.AuditMessage;
import org.dcm4che3.audit.AuditMessages;
import org.dcm4che3.audit.EventIdentification;
import org.dcm4che3.audit.ParticipantObjectIdentification;
import org.dcm4che3.conf.api.IApplicationEntityCache;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.hl7.HL7Segment;
import org.dcm4che3.net.Association;
import org.dcm4che3.net.Connection;
import org.dcm4che3.net.audit.AuditLogger;
import org.dcm4che3.net.hl7.UnparsedHL7Message;
import org.dcm4che3.util.ReverseDNS;
import org.dcm4chee.arc.HL7ConnectionEvent;
import org.dcm4chee.arc.audit.AuditInfo;
import org.dcm4chee.arc.audit.AuditInfoBuilder;
import org.dcm4chee.arc.audit.AuditService;
import org.dcm4chee.arc.audit.AuditUtils;
import org.dcm4chee.arc.audit.EventID;
import org.dcm4chee.arc.audit.HL7AuditUtils;
import org.dcm4chee.arc.audit.ParticipantObjectID;
import org.dcm4chee.arc.audit.SpoolFileReader;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.entity.Patient;
import org.dcm4chee.arc.hl7.ArchiveHL7Message;
import org.dcm4chee.arc.keycloak.HttpServletRequestInfo;
import org.dcm4chee.arc.procedure.ProcedureContext;

class ProcedureRecordAuditService {
    private ArchiveDeviceExtension arcDev;
    private ProcedureContext procCtx;
    private HL7ConnectionEvent hl7ConnEvent;
    private AuditInfoBuilder.Builder infoBuilder;
    private HL7Segment pid;

    ProcedureRecordAuditService(ProcedureContext ctx, ArchiveDeviceExtension arcDev) {
        this.procCtx = ctx;
        Patient patient = this.procCtx.getPatient();
        this.infoBuilder = new AuditInfoBuilder.Builder().studyUIDAccNumDate(this.procCtx.getAttributes(), arcDev).pIDAndName(patient != null ? patient.getAttributes() : ctx.getAttributes(), arcDev).mppsUID(this.procCtx.getMppsUID()).status(this.procCtx.getStatus()).outcome(this.procCtx.getOutcomeMsg() != null ? this.procCtx.getOutcomeMsg() : ProcedureRecordAuditService.outcome(this.procCtx.getException()));
        if (this.procCtx.getAttributes() == null && this.procCtx.getStudyInstanceUID() != null) {
            this.infoBuilder.studyIUID(this.procCtx.getStudyInstanceUID());
        }
    }

    ProcedureRecordAuditService(HL7ConnectionEvent hl7ConnEvent, ArchiveDeviceExtension arcDev) {
        this.arcDev = arcDev;
        this.hl7ConnEvent = hl7ConnEvent;
        this.pid = HL7AuditUtils.getHL7Segment(hl7ConnEvent.getHL7Message(), "PID");
    }

    AuditInfoBuilder getProcUpdateAuditInfo() {
        return this.procCtx.getHttpRequest() != null ? this.procUpdatedByWeb() : (this.procCtx.getAssociation() != null ? this.procUpdatedByMPPS() : (this.procCtx.getUnparsedHL7Message() != null ? this.procUpdatedByHL7() : this.procUpdatedByMWLImport()));
    }

    AuditInfoBuilder getHL7IncomingOrderInfo() {
        UnparsedHL7Message hl7Message = this.hl7ConnEvent.getHL7Message();
        HL7Segment msh = hl7Message.msh();
        this.infoBuilder = new AuditInfoBuilder.Builder().callingHost(this.hl7ConnEvent.getConnection().getHostname()).callingUserID(msh.getSendingApplicationWithFacility()).calledUserID(msh.getReceivingApplicationWithFacility()).studyIUID(HL7AuditUtils.procRecHL7StudyIUID(hl7Message, this.arcDev.auditUnknownStudyInstanceUID())).accNum(HL7AuditUtils.procRecHL7Acc(hl7Message)).outcome(ProcedureRecordAuditService.outcome(this.hl7ConnEvent.getException()));
        if (this.hasPIDSegment()) {
            this.infoBuilder.patID(this.pid.getField(3, null), this.arcDev).patName(this.pid.getField(5, null), this.arcDev);
        }
        return HL7AuditUtils.isOrderProcessed(this.hl7ConnEvent) ? this.orderProcessed() : this.infoBuilder.build();
    }

    AuditInfoBuilder getHL7OutgoingOrderInfo() {
        HL7Segment pid = HL7AuditUtils.getHL7Segment(this.hl7ConnEvent.getHL7Message(), "PID");
        UnparsedHL7Message hl7Message = this.hl7ConnEvent.getHL7Message();
        HL7Segment msh = hl7Message.msh();
        String sendingApplicationWithFacility = msh.getSendingApplicationWithFacility();
        String receivingApplicationWithFacility = msh.getReceivingApplicationWithFacility();
        this.infoBuilder = new AuditInfoBuilder.Builder().callingHost(ReverseDNS.hostNameOf((InetAddress)this.hl7ConnEvent.getSocket().getInetAddress())).callingUserID(sendingApplicationWithFacility).calledUserID(receivingApplicationWithFacility).studyIUID(HL7AuditUtils.procRecHL7StudyIUID(hl7Message, this.arcDev.auditUnknownStudyInstanceUID())).accNum(HL7AuditUtils.procRecHL7Acc(hl7Message)).outcome(ProcedureRecordAuditService.outcome(this.hl7ConnEvent.getException())).isOutgoingHL7().outgoingHL7Sender(sendingApplicationWithFacility).outgoingHL7Receiver(receivingApplicationWithFacility);
        return pid != null ? this.procRecForward(pid) : this.infoBuilder.build();
    }

    boolean hasPIDSegment() {
        return this.pid != null;
    }

    private AuditInfoBuilder procUpdatedByMPPS() {
        Association as = this.procCtx.getAssociation();
        return this.infoBuilder.callingUserID(as.getCallingAET()).callingHost(this.procCtx.getRemoteHostName()).calledUserID(as.getCalledAET()).build();
    }

    private AuditInfoBuilder procUpdatedByHL7() {
        UnparsedHL7Message msg = this.procCtx.getUnparsedHL7Message();
        return this.infoBuilder.callingUserID(msg.msh().getSendingApplicationWithFacility()).callingHost(this.procCtx.getRemoteHostName()).calledUserID(msg.msh().getReceivingApplicationWithFacility()).build();
    }

    private AuditInfoBuilder procUpdatedByWeb() {
        if (this.procCtx.getSourceMwlScp() != null) {
            return this.procUpdatedByMWLImport();
        }
        HttpServletRequestInfo httpServletRequestInfo = this.procCtx.getHttpRequest();
        return this.infoBuilder.callingUserID(httpServletRequestInfo.requesterUserID).callingHost(this.procCtx.getRemoteHostName()).calledUserID(this.requestURLWithQueryParams(httpServletRequestInfo)).build();
    }

    private String requestURLWithQueryParams(HttpServletRequestInfo httpServletRequestInfo) {
        return httpServletRequestInfo.queryString == null ? httpServletRequestInfo.requestURI : httpServletRequestInfo.requestURI + "?" + httpServletRequestInfo.queryString;
    }

    private AuditInfoBuilder procUpdatedByMWLImport() {
        HttpServletRequestInfo req = this.procCtx.getHttpRequest();
        AuditInfoBuilder.Builder auditInfoBuilder = this.infoBuilder.findSCP(this.procCtx.getSourceMwlScp()).destUserID(this.procCtx.getLocalAET());
        if (req != null) {
            auditInfoBuilder.callingUserID(req.requesterUserID).callingHost(this.procCtx.getRemoteHostName());
        }
        return auditInfoBuilder.build();
    }

    private AuditInfoBuilder orderProcessed() {
        ArchiveHL7Message archiveHL7Message;
        Attributes attrs;
        UnparsedHL7Message hl7ResponseMessage = this.hl7ConnEvent.getHL7ResponseMessage();
        if (hl7ResponseMessage instanceof ArchiveHL7Message && (attrs = (archiveHL7Message = (ArchiveHL7Message)hl7ResponseMessage).getStudyAttrs()) != null) {
            this.infoBuilder.studyIUID(attrs.getString(0x20000D)).accNum(attrs.getString(524368));
        }
        return this.infoBuilder.build();
    }

    private AuditInfoBuilder procRecForward(HL7Segment pid) {
        return this.infoBuilder.patID(pid.getField(3, null), this.arcDev).patName(pid.getField(5, null), this.arcDev).build();
    }

    private static String outcome(Exception e) {
        return e != null ? e.getMessage() : null;
    }

    static AuditMessage auditMsg(AuditLogger auditLogger, Path path, AuditUtils.EventType eventType, IApplicationEntityCache aeCache) {
        SpoolFileReader reader = new SpoolFileReader(path.toFile());
        AuditInfo auditInfo = new AuditInfo(reader.getMainInfo());
        return AuditMessages.createMessage((EventIdentification)EventID.toEventIdentification(auditLogger, path, eventType, auditInfo), (ActiveParticipant[])ProcedureRecordAuditService.activeParticipants(auditLogger, auditInfo, aeCache), (ParticipantObjectIdentification[])ParticipantObjectID.studyPatParticipants(auditInfo, reader, auditLogger));
    }

    private static ActiveParticipant[] activeParticipants(AuditLogger auditLogger, AuditInfo auditInfo, IApplicationEntityCache aeCache) {
        ActiveParticipant[] activeParticipants = new ActiveParticipant[3];
        String callingUserID = auditInfo.getField(1);
        String callingHost = auditInfo.getField(0);
        String findScp = auditInfo.getField(37);
        if (findScp != null) {
            activeParticipants[0] = new ActiveParticipantBuilder(findScp, AuditUtils.findScpHost(findScp, aeCache)).userIDTypeCode(AuditMessages.UserIDTypeCode.StationAETitle).build();
            ActiveParticipantBuilder destination = new ActiveParticipantBuilder(auditInfo.getField(12), ProcedureRecordAuditService.getLocalHostName(auditLogger)).userIDTypeCode(AuditMessages.UserIDTypeCode.StationAETitle).altUserID(AuditLogger.processID());
            if (callingUserID != null) {
                activeParticipants[1] = destination.build();
                activeParticipants[2] = new ActiveParticipantBuilder(callingUserID, callingHost).userIDTypeCode(AuditMessages.userIDTypeCode((String)callingUserID)).isRequester().build();
            } else {
                activeParticipants[1] = destination.isRequester().build();
            }
            return activeParticipants;
        }
        String calledUserID = auditInfo.getField(2);
        AuditMessages.UserIDTypeCode calledUserIDTypeCode = ProcedureRecordAuditService.userIDTypeCode(calledUserID);
        boolean isHL7Forward = auditInfo.getField(22) != null;
        ActiveParticipantBuilder callingUserParticipant = new ActiveParticipantBuilder(callingUserID, callingHost).userIDTypeCode(AuditService.remoteUserIDTypeCode(calledUserIDTypeCode, callingUserID));
        activeParticipants[0] = isHL7Forward ? callingUserParticipant.build() : callingUserParticipant.isRequester().build();
        activeParticipants[1] = new ActiveParticipantBuilder(calledUserID, ProcedureRecordAuditService.getLocalHostName(auditLogger)).userIDTypeCode(calledUserIDTypeCode).altUserID(AuditLogger.processID()).build();
        if (isHL7Forward) {
            activeParticipants[2] = new ActiveParticipantBuilder(auditLogger.getDevice().getDeviceName(), ProcedureRecordAuditService.getLocalHostName(auditLogger)).userIDTypeCode(AuditMessages.UserIDTypeCode.DeviceName).altUserID(AuditLogger.processID()).isRequester().build();
        }
        return activeParticipants;
    }

    private static String getLocalHostName(AuditLogger auditLogger) {
        return ((Connection)auditLogger.getConnections().get(0)).getHostname();
    }

    private static AuditMessages.UserIDTypeCode userIDTypeCode(String userID) {
        return userID.indexOf(47) != -1 ? AuditMessages.UserIDTypeCode.URI : (userID.indexOf(124) != -1 ? AuditMessages.UserIDTypeCode.ApplicationFacility : AuditMessages.UserIDTypeCode.StationAETitle);
    }
}

