/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.audit;

import java.nio.file.Path;
import org.dcm4che3.audit.ActiveParticipant;
import org.dcm4che3.audit.ActiveParticipantBuilder;
import org.dcm4che3.audit.AuditMessage;
import org.dcm4che3.audit.AuditMessages;
import org.dcm4che3.audit.EventIdentification;
import org.dcm4che3.audit.ParticipantObjectDetail;
import org.dcm4che3.audit.ParticipantObjectIdentification;
import org.dcm4che3.conf.api.ConfigurationException;
import org.dcm4che3.conf.api.IApplicationEntityCache;
import org.dcm4che3.net.Connection;
import org.dcm4che3.net.audit.AuditLogger;
import org.dcm4chee.arc.audit.AuditInfo;
import org.dcm4chee.arc.audit.AuditInfoBuilder;
import org.dcm4chee.arc.audit.AuditUtils;
import org.dcm4chee.arc.audit.EventID;
import org.dcm4chee.arc.audit.ParticipantObjectID;
import org.dcm4chee.arc.audit.SpoolFileReader;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.retrieve.ExternalRetrieveContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ExternalRetrieveAuditService {
    private static final Logger LOG = LoggerFactory.getLogger(ExternalRetrieveAuditService.class);

    ExternalRetrieveAuditService() {
    }

    static AuditInfoBuilder auditInfo(ExternalRetrieveContext ctx, ArchiveDeviceExtension arcDev) {
        AuditInfoBuilder.Builder auditInfo = ctx.getHttpServletRequestInfo() == null ? ExternalRetrieveAuditService.auditInfoForScheduler(ctx) : ExternalRetrieveAuditService.auditInfoForRESTful(ctx);
        return auditInfo.callingHost(ctx.getRequesterHostName()).calledHost(ctx.getRemoteHostName()).destUserID(ctx.getDestinationAET()).studyUIDAccNumDate(ctx.getKeys(), arcDev).warning(ctx.warning() > 0 ? "Number Of Warning Sub operations" + ctx.warning() : null).outcome(ctx.getResponse().getString(2306) != null ? ctx.getResponse().getString(2306) + ctx.failed() : null).build();
    }

    private static AuditInfoBuilder.Builder auditInfoForRESTful(ExternalRetrieveContext ctx) {
        return new AuditInfoBuilder.Builder().callingUserID(ctx.getRequesterUserID()).calledUserID(ctx.getRemoteAET()).moveUserID(ctx.getRequestURI());
    }

    private static AuditInfoBuilder.Builder auditInfoForScheduler(ExternalRetrieveContext ctx) {
        return new AuditInfoBuilder.Builder().callingUserID(ctx.getLocalAET()).findSCP(ctx.getFindSCP()).moveUserID(ctx.getRemoteAET());
    }

    static AuditMessage auditMsg(AuditLogger auditLogger, Path path, AuditUtils.EventType eventType, IApplicationEntityCache aeCache) {
        SpoolFileReader reader = new SpoolFileReader(path);
        AuditInfo auditInfo = new AuditInfo(reader.getMainInfo());
        return AuditMessages.createMessage((EventIdentification)EventID.toEventIdentification(auditLogger, path, eventType, auditInfo), (ActiveParticipant[])ExternalRetrieveAuditService.activeParticipants(auditLogger, eventType, auditInfo, aeCache), (ParticipantObjectIdentification[])new ParticipantObjectIdentification[]{ParticipantObjectID.studyPOI(auditInfo.getField(4)).detail(new ParticipantObjectDetail[]{AuditMessages.createParticipantObjectDetail((String)"StudyDate", (String)auditInfo.getField(9))}).build()});
    }

    private static ActiveParticipant[] activeParticipants(AuditLogger auditLogger, AuditUtils.EventType eventType, AuditInfo auditInfo, IApplicationEntityCache aeCache) {
        return auditInfo.getField(0) == null ? ExternalRetrieveAuditService.schedulerTriggeredAPs(auditLogger, eventType, auditInfo, aeCache) : ExternalRetrieveAuditService.restfulTriggeredAPs(auditLogger, eventType, auditInfo);
    }

    private static ActiveParticipant[] restfulTriggeredAPs(AuditLogger auditLogger, AuditUtils.EventType eventType, AuditInfo auditInfo) {
        ActiveParticipant[] activeParticipants = new ActiveParticipant[4];
        String userID = auditInfo.getField(1);
        activeParticipants[0] = new ActiveParticipantBuilder(userID, auditInfo.getField(0)).userIDTypeCode(AuditMessages.userIDTypeCode((String)userID)).isRequester().build();
        activeParticipants[1] = new ActiveParticipantBuilder(auditInfo.getField(14), ExternalRetrieveAuditService.getLocalHostName(auditLogger)).userIDTypeCode(AuditMessages.UserIDTypeCode.URI).altUserID(AuditLogger.processID()).build();
        activeParticipants[2] = new ActiveParticipantBuilder(auditInfo.getField(2), auditInfo.getField(3)).userIDTypeCode(AuditMessages.UserIDTypeCode.StationAETitle).roleIDCode(new AuditMessages.RoleIDCode[]{eventType.source}).build();
        activeParticipants[3] = new ActiveParticipantBuilder(auditInfo.getField(12), auditInfo.getField(13)).userIDTypeCode(AuditMessages.UserIDTypeCode.StationAETitle).roleIDCode(new AuditMessages.RoleIDCode[]{eventType.destination}).build();
        return activeParticipants;
    }

    private static ActiveParticipant[] schedulerTriggeredAPs(AuditLogger auditLogger, AuditUtils.EventType eventType, AuditInfo auditInfo, IApplicationEntityCache aeCache) {
        ActiveParticipant[] activeParticipants = new ActiveParticipant[4];
        String userID = auditInfo.getField(1);
        String findSCP = auditInfo.getField(37);
        activeParticipants[0] = new ActiveParticipantBuilder(userID, ExternalRetrieveAuditService.getLocalHostName(auditLogger)).userIDTypeCode(AuditMessages.UserIDTypeCode.StationAETitle).altUserID(AuditLogger.processID()).isRequester().build();
        activeParticipants[1] = new ActiveParticipantBuilder(auditInfo.getField(14), auditInfo.getField(3)).userIDTypeCode(AuditMessages.UserIDTypeCode.StationAETitle).roleIDCode(new AuditMessages.RoleIDCode[]{eventType.source}).build();
        activeParticipants[2] = new ActiveParticipantBuilder(auditInfo.getField(12), auditInfo.getField(13)).userIDTypeCode(AuditMessages.UserIDTypeCode.StationAETitle).roleIDCode(new AuditMessages.RoleIDCode[]{eventType.destination}).build();
        try {
            activeParticipants[3] = new ActiveParticipantBuilder(findSCP, ((Connection)aeCache.findApplicationEntity(findSCP).getConnections().get(0)).getHostname()).userIDTypeCode(AuditMessages.UserIDTypeCode.StationAETitle).build();
        }
        catch (ConfigurationException e) {
            LOG.info("Exception caught on getting hostname for C-FINDSCP : {}", (Object)e.getMessage());
        }
        return activeParticipants;
    }

    private static String getLocalHostName(AuditLogger auditLogger) {
        return ((Connection)auditLogger.getConnections().get(0)).getHostname();
    }
}

