/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.audit;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Calendar;
import java.util.HashSet;
import org.dcm4che3.audit.AuditMessages;
import org.dcm4che3.audit.EventIdentification;
import org.dcm4che3.audit.EventIdentificationBuilder;
import org.dcm4che3.audit.EventTypeCode;
import org.dcm4che3.data.Code;
import org.dcm4che3.net.audit.AuditLogger;
import org.dcm4chee.arc.audit.AuditInfo;
import org.dcm4chee.arc.audit.AuditUtils;
import org.dcm4chee.arc.entity.Patient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EventID {
    private static final Logger LOG = LoggerFactory.getLogger(EventID.class);

    EventID() {
    }

    static EventIdentification toEventIdentification(AuditLogger auditLogger, Path path, AuditUtils.EventType eventType, AuditInfo auditInfo) {
        Event event = new Event(auditInfo, eventType);
        return new EventIdentificationBuilder(eventType.eventID, eventType.eventActionCode, EventID.getEventTime(path, auditLogger), event.outcomeIndicator).outcomeDesc(event.outcomeDescription).eventTypeCode(new EventTypeCode[]{event.eventTypeCode}).build();
    }

    static EventIdentification toEventIdentification(AuditUtils.EventType eventType) {
        return new EventIdentificationBuilder(eventType.eventID, eventType.eventActionCode, null, "0").eventTypeCode(new EventTypeCode[]{eventType.eventTypeCode}).build();
    }

    static EventIdentification toEventIdentification(AuditLogger auditLogger, Path path, AuditUtils.EventType eventType, HashSet<String> outcome, HashSet<AuditMessages.EventTypeCode> errorCode) {
        return new EventIdentificationBuilder(eventType.eventID, eventType.eventActionCode, EventID.getEventTime(path, auditLogger), "4").outcomeDesc(String.join((CharSequence)"\n", outcome)).eventTypeCode((EventTypeCode[])errorCode.toArray(new AuditMessages.EventTypeCode[0])).build();
    }

    private static Calendar getEventTime(Path path, AuditLogger auditLogger) {
        Calendar eventTime = auditLogger.timeStamp();
        try {
            eventTime.setTimeInMillis(Files.getLastModifiedTime(path, new LinkOption[0]).toMillis());
        }
        catch (Exception e) {
            LOG.info("Failed to get Last Modified Time of [AuditSpoolFile={}] of [AuditLogger={}]\n", new Object[]{path, auditLogger.getCommonName(), e});
        }
        return eventTime;
    }

    static class Event {
        private String outcomeIndicator;
        private String outcomeDescription;
        private AuditMessages.EventTypeCode eventTypeCode;

        Event(AuditInfo auditInfo, AuditUtils.EventType eventType) {
            String patMismatchCode = auditInfo.getField(30);
            String patVerStatus = auditInfo.getField(32);
            Patient.VerificationStatus patVerificationStatus = patVerStatus != null ? Patient.VerificationStatus.valueOf((String)patVerStatus) : null;
            String outcome = auditInfo.getField(8);
            String status = auditInfo.getField(39);
            AuditMessages.EventTypeCode eventTypeCode = this.eventTypeCode = patMismatchCode != null ? this.patMismatchEventTypeCode(patMismatchCode) : eventType.eventTypeCode;
            String string = outcome != null || patMismatchCode != null || patVerificationStatus == Patient.VerificationStatus.NOT_FOUND ? "4" : (this.outcomeIndicator = patVerificationStatus == Patient.VerificationStatus.VERIFICATION_FAILED ? "8" : "0");
            this.outcomeDescription = this.eventTypeCode != null ? this.eventTypeCode.getOriginalText() : (outcome != null ? (patVerificationStatus != null ? patVerificationStatus.name() + " " + outcome : (status != null ? status + " " + outcome : outcome)) : (patVerificationStatus != null ? patVerificationStatus.name() : (status != null ? status : auditInfo.getField(15))));
        }

        private AuditMessages.EventTypeCode patMismatchEventTypeCode(String patMismatchCode) {
            try {
                Code code = new Code(patMismatchCode);
                return new AuditMessages.EventTypeCode(code.getCodeValue(), code.getCodingSchemeDesignator(), code.getCodeMeaning());
            }
            catch (Exception e) {
                LOG.info("Invalid patient mismatch code: {}", (Object)patMismatchCode);
                return null;
            }
        }
    }
}

