/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.audit;

import java.nio.file.Path;
import org.dcm4che3.audit.ActiveParticipant;
import org.dcm4che3.audit.ActiveParticipantBuilder;
import org.dcm4che3.audit.AuditMessage;
import org.dcm4che3.audit.AuditMessages;
import org.dcm4che3.audit.EventIdentification;
import org.dcm4che3.audit.ParticipantObjectIdentification;
import org.dcm4che3.net.audit.AuditLogger;
import org.dcm4chee.arc.ConnectionEvent;
import org.dcm4chee.arc.audit.AuditInfo;
import org.dcm4chee.arc.audit.AuditInfoBuilder;
import org.dcm4chee.arc.audit.AuditUtils;
import org.dcm4chee.arc.audit.EventID;
import org.dcm4chee.arc.audit.SpoolFileReader;

class ConnectionEventsAuditService {
    ConnectionEventsAuditService() {
    }

    static AuditInfoBuilder connFailureAuditInfo(ConnectionEvent event) {
        return event.getType() == ConnectionEvent.Type.FAILED ? ConnectionEventsAuditService.connFailedAuditInfo(event) : ConnectionEventsAuditService.connRejectedAuditInfo(event);
    }

    private static AuditInfoBuilder connRejectedAuditInfo(ConnectionEvent event) {
        String callingUser = event.getSocket().getRemoteSocketAddress().toString();
        return new AuditInfoBuilder.Builder().callingUserID(callingUser).callingHost(callingUser).calledUserID(event.getConnection().getDevice().getDeviceName()).calledHost(event.getConnection().getHostname()).outcome(event.getException().getMessage()).connType(event.getType()).build();
    }

    private static AuditInfoBuilder connFailedAuditInfo(ConnectionEvent event) {
        return new AuditInfoBuilder.Builder().callingUserID(event.getConnection().getDevice().getDeviceName()).callingHost(event.getConnection().getHostname()).calledUserID(event.getRemoteConnection().getHostname()).calledHost(event.getRemoteConnection().getHostname()).outcome(event.getException().getMessage()).connType(event.getType()).build();
    }

    static AuditMessage auditMsg(AuditLogger auditLogger, Path path, AuditUtils.EventType eventType) {
        SpoolFileReader reader = new SpoolFileReader(path);
        AuditInfo auditInfo = new AuditInfo(reader.getMainInfo());
        return AuditMessages.createMessage((EventIdentification)EventID.toEventIdentification(auditLogger, path, eventType, auditInfo), (ActiveParticipant[])ConnectionEventsAuditService.activeParticipants(auditInfo), (ParticipantObjectIdentification[])new ParticipantObjectIdentification[0]);
    }

    private static ActiveParticipant[] activeParticipants(AuditInfo auditInfo) {
        ActiveParticipant[] activeParticipants = new ActiveParticipant[2];
        if (ConnectionEvent.Type.valueOf((String)auditInfo.getField(31)) == ConnectionEvent.Type.REJECTED) {
            activeParticipants[0] = new ActiveParticipantBuilder(auditInfo.getField(2), auditInfo.getField(3)).userIDTypeCode(AuditMessages.UserIDTypeCode.DeviceName).altUserID(AuditLogger.processID()).build();
            activeParticipants[1] = new ActiveParticipantBuilder(auditInfo.getField(1), auditInfo.getField(0)).userIDTypeCode(AuditMessages.UserIDTypeCode.NodeID).isRequester().build();
        } else {
            activeParticipants[0] = new ActiveParticipantBuilder(auditInfo.getField(2), auditInfo.getField(3)).userIDTypeCode(AuditMessages.UserIDTypeCode.NodeID).build();
            activeParticipants[1] = new ActiveParticipantBuilder(auditInfo.getField(1), auditInfo.getField(0)).userIDTypeCode(AuditMessages.UserIDTypeCode.DeviceName).altUserID(AuditLogger.processID()).isRequester().build();
        }
        return activeParticipants;
    }
}

