/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.audit;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import org.dcm4che3.util.StringUtils;
import org.dcm4chee.arc.audit.AuditInfoBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AuditInfo {
    private static final Logger LOG = LoggerFactory.getLogger(AuditInfo.class);
    static final int CALLING_HOST = 0;
    static final int CALLING_USERID = 1;
    static final int CALLED_USERID = 2;
    static final int CALLED_HOST = 3;
    static final int STUDY_UID = 4;
    static final int ACC_NUM = 5;
    static final int P_ID = 6;
    static final int P_NAME = 7;
    static final int OUTCOME = 8;
    static final int STUDY_DATE = 9;
    static final int Q_POID = 10;
    static final int Q_STRING = 11;
    static final int DEST_USER_ID = 12;
    static final int DEST_NAP_ID = 13;
    static final int MOVE_USER_ID = 14;
    static final int WARNING = 15;
    static final int FAILED_IUID_SHOW = 16;
    static final int SOP_CUID = 17;
    static final int SOP_IUID = 18;
    static final int MPPS_UID = 19;
    static final int SUBMISSION_SET_UID = 20;
    static final int IS_EXPORT = 21;
    static final int IS_OUTGOING_HL7 = 22;
    static final int OUTGOING_HL7_SENDER = 23;
    static final int OUTGOING_HL7_RECEIVER = 24;
    static final int FILTERS = 25;
    static final int COUNT = 26;
    static final int QUEUE_MSG = 27;
    static final int TASK_POID = 28;
    static final int ERROR_CODE = 29;
    static final int PAT_MISMATCH_CODE = 30;
    static final int CONN_TYPE = 31;
    static final int PAT_VERIFICATION_STATUS = 32;
    static final int PDQ_SERVICE_URI = 33;
    static final int IMPAX_ENDPOINT = 34;
    static final int FAILED = 35;
    static final int EXPIRATION_DATE = 36;
    static final int FIND_SCP = 37;
    static final int QUEUE_NAME = 38;
    static final int STATUS = 39;
    static final int FHIR_WEB_APP_NAME = 40;
    private final String[] fields;

    AuditInfo(AuditInfoBuilder i) {
        this.fields = new String[]{AuditInfo.encode(i.callingHost), AuditInfo.encode(i.callingUserID), AuditInfo.encode(i.calledUserID), AuditInfo.encode(i.calledHost), AuditInfo.encode(i.studyUID), AuditInfo.encode(i.accNum), AuditInfo.encode(i.pID), AuditInfo.encode(i.pName), AuditInfo.encode(i.outcome), AuditInfo.encode(i.studyDate), AuditInfo.encode(i.queryPOID), AuditInfo.encode(i.queryString), AuditInfo.encode(i.destUserID), AuditInfo.encode(i.destNapID), AuditInfo.encode(i.moveUserID), AuditInfo.encode(i.warning), AuditInfo.encode(i.failedIUIDShow ? String.valueOf(true) : null), AuditInfo.encode(i.sopCUID), AuditInfo.encode(i.sopIUID), AuditInfo.encode(i.mppsUID), AuditInfo.encode(i.submissionSetUID), AuditInfo.encode(i.isExport ? String.valueOf(true) : null), AuditInfo.encode(i.isOutgoingHL7 ? String.valueOf(true) : null), AuditInfo.encode(i.outgoingHL7Sender), AuditInfo.encode(i.outgoingHL7Receiver), AuditInfo.encode(i.filters), AuditInfo.encode(String.valueOf(i.count)), AuditInfo.encode(i.queueMsg), AuditInfo.encode(i.taskPOID), AuditInfo.encode(i.errorCode), AuditInfo.encode(i.patMismatchCode), AuditInfo.encode(i.connType != null ? i.connType.name() : null), AuditInfo.encode(i.patVerificationStatus != null ? i.patVerificationStatus.name() : null), AuditInfo.encode(i.pdqServiceURI), AuditInfo.encode(i.impaxEndpoint), AuditInfo.encode(String.valueOf(i.failed)), AuditInfo.encode(i.expirationDate), AuditInfo.encode(i.findSCP), AuditInfo.encode(i.queueName), AuditInfo.encode(i.status), AuditInfo.encode(i.fhirWebAppName)};
    }

    AuditInfo(String s) {
        this.fields = StringUtils.split((String)s, (char)'\\');
    }

    String getField(int field) {
        return AuditInfo.decode(StringUtils.maskEmpty((String)this.fields[field], null));
    }

    private static String decode(String val) {
        if (val == null) {
            return null;
        }
        try {
            return URLDecoder.decode(val, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOG.info("URL decoding of value {} failed", (Object)val);
            return val;
        }
    }

    private static String encode(String val) {
        if (val == null) {
            return null;
        }
        try {
            return URLEncoder.encode(val, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOG.info("URL encoding of value {} failed", (Object)val);
            return val;
        }
    }

    public String toString() {
        return StringUtils.concat((String[])this.fields, (char)'\\');
    }
}

